#ifndef CCWAV_H
#define CCWAV_H

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define CCWAV_EXPORT __cdecl

// ##############################################################################################################################################################################
// #
// # ERROR CODE DEFINITION
// # 
// ##############################################################################################################################################################################

// RESULT OF FUNCTION
//
typedef enum {

	CCWAV_RS_SUCCESSFUL									= 0x00000000,

	CCWAV_RS_ERROR_GENERAL							= 0x00000001,

	CCWAV_RS_ERROR_OUT_OF_MEMORY			= 0x00000002,	

	CCWAV_RS_ERROR_OUT_OF_RESOURCE		= 0x00000003,

	CCWAV_RS_ERROR_INVALID_FILE					= 0x00000004,

	CCWAV_RS_ERROR_INVALID_PARAMETER	= 0x00000005,

	CCWAV_RS_ERROR_NON_SUPPORT					= 0x00000006,	

} CCWAV_QRESULT;

typedef enum {

	CCWAV_PCM			= 0x00000000	

} CCWAV_AUDIO_FORMAT;

typedef void * WAVFILE;

AFX_EXT_API CCWAV_QRESULT CCWAV_EXPORT CcWavCreateFile(const CHAR * pszFileName /*IN*/, const CHAR * pMode /*IN*/, WAVFILE * ppWavFile /*OUT*/);

// EXAMPLE : CcWavCreateFile( "D:\\CH01.WAV", "w", &pWavFileA );

AFX_EXT_API CCWAV_QRESULT CCWAV_EXPORT CcWavReleaseFile(WAVFILE pWavFile /*IN*/);

// EXAMPLE : CcWavReleaseFile( pWavFile );

AFX_EXT_API CCWAV_QRESULT CCWAV_EXPORT CcWavSetAudioFormat(WAVFILE pWavFile /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSamplesPerSec /*IN*/, ULONG nAudioFormat /*IN*/ );

// EXAMPLE : CcWavSetAudioFormat( pWavFile, 2, 16, 48000, CCWAV_PCM );  // STEREO / 16BITS / 48000HZ

AFX_EXT_API CCWAV_QRESULT CCWAV_EXPORT CcWavWriteAudioSampleBuffer(WAVFILE pWavFile /*IN*/, BYTE * pWaveBuffer /*IN*/, ULONG nWaveBufferSize /*IN*/ );

// EXAMPLE : CcWavWriteAudioSampleBuffer( pWavFile, pWaveBuffer, nWaveBufferSize );

#endif // CCWAV_H